 ; Ŀ
 ;   Rel - make crap back into a leader.                                   
 ;   Copyright 2008 by Rocket Software Ltd.                                
 ;   "Every bite was an explosion of toast." - Joy.                        
 ; 

 ; Ŀ
 ;   Bazang - given a list of three points, find the angle between a       
 ;   line from the first one to a line between the two others.             
 ;   Arguments: Ptlist, a list of three points.                            
 ;              Colo, a grdraw colour for test lines, ignore if nil.       
 ;   Calls nothing.                                                        
 ;   Returns a list: the angle difference and the angle between the first  
 ;   point and the point midway between the two others.                    
 ; 
 (DEFUN BAZANG (ptlist colo / pa pb pc basex basey basez base arang bangle)
  (setq pa (car ptlist))
  (setq pb (cadr ptlist))
  (setq pc (caddr ptlist))
 ; Ŀ
 ;   Get the middle of the side defined by the pb and pc.                  
 ; 
  (setq basex (/ (+ (car pb) (car pc)) 2))
  (setq basey (/ (+ (cadr pb) (cadr pc)) 2))
  (setq basez (/ (+ (caddr pb) (caddr pc)) 2))
  (setq base (list basex basey basez))  ; middle of back edge
 ; Ŀ
 ;   Get the angle from pa to the middle of the opposite side.             
 ; 
  (setq arang (angle pa base))
 ; Ŀ
 ;   Get the opposite side angle (pb to pc).                               
 ; 
  (setq bangle (angle pb pc))
 ; Ŀ
 ;   Make some nice test graphic lines.                                    
 ; 
  (if colo
      (progn
           (grdraw pa base colo)
           (grdraw pb pc colo)))
 ; Ŀ
 ;   Return the smallest difference between the two angles.                
 ; 
 (list (abs (rem (- arang bangle) pi)) arang))
 ; Ŀ
 ;   Bazang end.                                                           
 ; 

 ; Ŀ
 ;   Jlist - add a two point list to a base list so that the closest       
 ;   points (ideally identical ones) are together and are replaced with    
 ;   one point.                                                            
 ;   Arguments: Base, the list to add to.                                  
 ;              Gnulst, the list to add to Base.                           
 ;   Calls nothing, returns a combined list.                               
 ; 
 (DEFUN JLIST (base gnulst / pa pb pc pd ac ad bc bd dmin)
 ; Ŀ
 ;   Extract the endpoints of each list.                                   
 ; 
  (setq pa (car base))
  (setq pb (last base))
  (setq pc (car gnulst))
  (setq pd (last gnulst))
 ; Ŀ
 ;   Find the closest two points.                                          
 ; 
  (setq ac (distance pa pc))
  (setq ad (distance pa pd))
  (setq bc (distance pb pc))
  (setq bd (distance pb pd))
  (setq dmin (min ac ad bc bd))
 ; Ŀ
 ;   And join the lists accodingly.                                        
 ; 
  (cond ((= dmin ac)
         (setq base (append (reverse (cdr gnulst)) base)))
        ((= dmin ad)
         (setq base (append (reverse (cdr (reverse gnulst))) base)))
        ((= dmin bc)
         (setq base (append base (cdr gnulst))))
        ((= dmin bd)
         (setq base (append base (reverse (cdr (reverse gnulst)))))))
 base)
 ; Ŀ
 ;   Jlist end.                                                            
 ; 

 ; Ŀ
 ;   Listi - make a list of strings into one string.                       
 ;   Arguments: Alist, a list of strings.                                  
 ;              Sepstr, the separator string.                              
 ;   Returns a string.                                                     
 ; 
 (DEFUN LISTI (alist sepstr / thestr len)
  (setq thestr "")
 ; Ŀ
 ;   You don't ever really have to have mapcar, but it is nice...          
 ; 
  (mapcar '(lambda (astr)
            (setq thestr (strcat thestr sepstr astr)))
            alist)
 ; Ŀ
 ;   Remove the extraneous copy of sepstr from the string end.             
 ; 
  (if (> (strlen thestr) (setq len (strlen sepstr)))
      (setq thestr (substr thestr (1+ len))))
 thestr)
 ; Ŀ
 ;   Listi end.                                                            
 ; 

 ; Ŀ
 ;   Triarp - see if a solid is triangular, if so return the endpoint      
 ;   and the angle to the middle of the opposite side.                     
 ;   Arguments: Arrnam, the solid ename.                                   
 ;   Calls Bazang.                                                         
 ;   Returns a point point and an angle or nil.                            
 ; 
 (DEFUN TRIARP (arrnam / arr plist num pa gnulis angg arang thangl axang panu)
 ; Ŀ
 ;   If the user ends the solid command after three points then the 12     
 ;   and 13 groups are the same point.  On the other hand, they may have   
 ;   just dragged one point onto another, so you can't assume this.        
 ; 
  (setq arr (entget arrnam))
  (setq plist (list (cdr (assoc 10 arr)) (cdr (assoc 11 arr))
                    (cdr (assoc 12 arr)) (cdr (assoc 13 arr))))
 ; Ŀ
 ;   Make a new list without duplicate points.                             
 ; 
  (setq num 0)
  (while (setq pa (nth num plist))
         (setq num (1+ num))
         (if (not (member pa gnulis))
             (setq gnulis (cons pa gnulis))))
 ; Ŀ
 ;   Find the point for which a line between it and the midpoint of the    
 ;   opposite side is closest to making a right angle with the opposite    
 ;   side.                                                                 
 ; 
  (if (= (length gnulis) 3)
      (progn
           (repeat 3
                   (setq angg (bazang gnulis nil))
                   (setq arang (cadr angg))
                   (setq angg (car angg))
                   (setq angg (abs (- angg (/ pi 2))))
                   (if (or (null thangl) (< angg thangl))
                       (progn
                            (setq thangl angg)
                            (setq axang arang)
                            (setq panu (car gnulis))))
                   (setq gnulis (cons (last gnulis)
                                      (reverse (cdr (reverse gnulis))))))
 ;         (grdraw panu (polar panu axang 12) 142)
 ; Ŀ
 ;   Return a list of the point and the angle to the back midpoint or nil. 
 ; 
           (list panu axang))))
 ; Ŀ
 ;   Triarp end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Lwppts - get a list of lwpolyline vertex locations.        
 ;   Arguments: Enam, a lwpolyline ename.                                  
 ;                                                                         
 ; 
 (DEFUN LWPPTS (enam / entt num sub palist)
  (setq entt (entget enam))
  (setq num 0)
  (while (setq sub (nth num entt))
         (setq num (1+ num))
         (if (= (car sub) 10)
             (setq palist (cons (cdr sub) palist))))
 palist)
 ; Ŀ
 ;   Lwppts end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Vtxpts - get a list of polyline vertex locations.          
 ;   Arguments: Enam, a polyline ename.                                    
 ;                                                                         
 ; 
 (DEFUN VTXPTS (enam / entt pa palist)
  (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                               (setq enam (entnext enam)))))))
         (setq pa (cdr (assoc 10 entt)))
         (setq palist (cons pa palist)))
 palist)
 ; Ŀ
 ;   Vtxpts end.                                                           
 ; 

 ; Ŀ
 ;   Rel.                                                                  
 ; 
 (DEFUN C:REL (/ osmo clay *error* ss num enam entt typ lwp po so in l2n l1n
                                                    ctxlay ptlis pts1 pts2 pa)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
  (setq clay (getvar "clayer"))
 ; Ŀ
 ;   Make a local error handler.                                           
 ; 
  (defun *error* (shk)
   (setvar "osmode" osmo)
   (setvar "clayer" clay)
   (command "undo" "end")
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   Make the text layer current.                                          
 ; 
  (if malaya (malaya "text"))
 ; Ŀ
 ;   Get some entities.                                                    
 ; 
  (prompt "Select ex-leader entities: ")
  (if (setq ss (ssget (list (cons 0
                       "polyline,lwpolyline,line,insert,solid,text,mtext"))))
      (progn
 ; Ŀ
 ;   There should be two possibilities: two lines and a block or solid,    
 ;   or a polyline or lwpolyline and a block or a solid.                   
 ;   There should also be either two or three entities.  Any more and it   
 ;   isn't likely to be clear what is going on.                            
 ; 
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq entt (entget enam))
                  (setq num (1+ num))
                  (setq typ (cdr (assoc 0 entt)))
 ; Ŀ
 ;   Save the entity name to a variable named after its type.              
 ; 
                  (cond ((= typ "LWPOLYLINE")
                         (setq lwp enam))
                        ((= typ "POLYLINE")
                         (setq po enam))
                        ((= typ "SOLID")
                         (setq so enam))
                        ((= typ "INSERT")
                         (setq in enam))
                        ((and (= typ "LINE") l1n)
                         (setq l2n enam))
                        ((= typ "LINE")
                         (setq l1n enam))))
 ; Ŀ
 ;   Use the end closest to the solid or block as the pointer end,         
 ;   in case the pline is only a single line segment.                      
 ;   If that is the case ... leave it alone, so as not to have to move     
 ;   the text.  But will this automatically generate an end segment?       
 ; 
 ; Ŀ
 ;   Get a list of polyline vertices or line endpoints.                    
 ; 
           (cond (po
                  (setq ptlis (vtxpts po)))
                 (lwp
                  (setq ptlis (lwppts lwp)))
                 ((and l1n l2n)
                  (setq entt (entget l1n))
                  (setq pts1 (list (cdr (assoc 10 entt))
                                   (cdr (assoc 11 entt))))
                  (setq entt (entget l2n))
                  (setq pts2 (list (cdr (assoc 10 entt))
                                   (cdr (assoc 11 entt))))
                  (setq ptlis (jlist pts1 pts2)))
                 (l1n
                  (setq entt (entget l1n))
                  (setq ptlis (list (cdr (assoc 10 entt))
                                    (cdr (assoc 11 entt))))))
 ; Ŀ
 ;   Get the arrowhead point, else error.                                  
 ; 
           (cond (in
                  (setq pa (cdr (assoc (entget in)))))
                 (so
                  (setq pa (car (triarp so)))))
           (if (null pa)
               (progn
                    (*error* "No arrowhead found.")
                    (exit)))
 ; Ŀ
 ;   Make sure the first point in the polyline list is the one closest     
 ;   to the arrowhead point.                                               
 ; 
           (if (> (distance pa (car ptlis))
                  (distance pa (car (reverse ptlis))))
               (setq ptlis (reverse ptlis)))
 ; Ŀ
 ;   Start at the arrowhead point, then proceed along the polyline,        
 ;   dropping the first polyline point.                                    
 ; 
           (setq ptlis (cons pa (cdr ptlis)))
 ; Ŀ
 ;   Draw the leader.                                                      
 ; 
           (command ".leader")
           (while (setq pa (car ptlis))
                  (command pa)
                  (setq ptlis (cdr ptlis)))
           (command "" "" "n")
 ; Ŀ
 ;   Put text on the current (text) layer, or whatever Malaya made,        
 ;   remove it from the ss so that it won't be erased.                     
 ; 
          (setq ctxlay (getvar "clayer"))
          (setq num 0)
          (while (setq enam (ssname ss num))
                 (setq entt (entget enam))
                 (if (member (cdr (assoc 0 entt)) '("TEXT" "MTEXT"))
                     (progn
                          (entmod (subst (cons 8 ctxlay) (assoc 8 entt) entt))
                          (ssdel enam ss))
                     (setq num (1+ num))))
 ; Ŀ
 ;   Erase the previous non-text stuff.                                    
 ; 
           (command ".erase" ss "")))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (*error* ())
 (princ))